#!/bin/sh
RED='\033[0;31m'
LTGREEN='\033[1;32m'
NC='\033[0m' # No Color
BRANCHVERSION=00
BRANCHVERSION4HARDCODED=SV2-4.00.00
#===============
#FUNCTIONS START
#===============
function getLatestVersion()
{   
    latestVersion=0
    worktemp=/tmp
    view=Folders
    curl -k http://jenkinssv2:8080/view/${view}/ -o ${worktemp}/temp.txt
    grep -F 'Trunk' "${worktemp}/temp.txt" > ${worktemp}/after
    latestVersion=$(cat ${worktemp}/after | grep -o -m1 SV2_[1-9].[0-9][0-9].[0-9][0-9]_Trunk | grep -o -m1 [1-9].[0-9][0-9].[0-9][0-9])
    echo ${latestVersion}
    rm ${worktemp}/temp.txt
    rm ${worktemp}/after

}
BRANCHVERSION=$(getLatestVersion)
BRANCHFOLDER=SV2-${BRANCHVERSION}
#BRANCHVERSIONLEGACY=1.07.00
#BRANCHFOLDERLEGACY=SV2-${BRANCHVERSIONLEGACY}
LOCALPATH=/tmp/deploy
SVNPATHONSERVER=svn://trantor.matrox.com/mgisoft/Tools/Linux/Yocto/devkit-SV2/Trunk/meta-matrox/recipes-magni/deploysv2/files/
SVNSCRIPTS=svn://trantor.matrox.com/mgisoft/Tools/Linux/Jenkins/MeOS_Scripts
#jenkinsprojectname1_8=http://jenkinssv2.matrox.com:8080/job/${BRANCHFOLDERLEGACY}/job/SV2_Build-L_MeOS_Toolchain1.8.1
jenkinsprojectname4_4=http://jenkinssv2.matrox.com:8080/job/${BRANCHFOLDER}/job/SV2_Build-L_MeOS_Toolchain
jenkinsprojectname5_4=http://jenkinssv2.matrox.com:8080/job/${BRANCHVERSION4HARDCODED}/job/SV2_Build-L_MeOS4.0_Toolchain
jenkinsprojectpublicname=http://jenkinssv2.matrox.com:8080/job/${BRANCHFOLDER}/job/SV2_Build-L_MeOS_Toolchain_Public
jenkinsprojectAVSL=http://jenkinssv2.matrox.com:8080/job/${BRANCHFOLDER}/job/SV2_Build-L_AVSL_ALL_rpms
RepoFile=MeOSRepo3.00-3.08


#===============
#FUNCTIONS Continue
#===============
function ClearLocalPath()
{
    if [ -d ${LOCALPATH}/ ]; then  rm -rf ${LOCALPATH}/; fi
    if [ ! -d "${LOCALPATH}/" ]; then mkdir -p ${LOCALPATH}/; fi
    cd ${LOCALPATH}
}
function ShowHelp()
{
    echo
    echo
    echo -e .    This script ${LTGREEN}deploy.sh${NC} is used to copy.
    echo .    The sv2 compiled package from Jenkins.
    echo .    To download a specific build version, from ${BRANCHVERSION}
    echo .    Add the version you wish to download as a parameter.
    echo .    Or type last as a parameter, for the last Successful build. 
    echo .    Default with no parameter, will use the last promoted build.
    echo -e . example: ${LTGREEN}./deploy 1022${NC}
    echo -e . ${LTGREEN}-fix${NC}        Will Fix the channel by adding one. 
    echo .  If a channel already exists, ctrl-c to exit.
    echo -e . ${LTGREEN}-last${NC}            example: ${LTGREEN}./deploy last${NC}
    echo -e . ${LTGREEN}-repo${NC}        Installs Matrox Repository
    echo -e . ${LTGREEN}-r${NC}        Removes the installed liberatus-runtime rpm.
    echo -e . ${LTGREEN}-public${NC}        Fetch package from Public Project on Jenkins path.
    echo -e . ${LTGREEN}-avsl${NC}          Fetch package from AVSL Project on Jenkins path.
    echo -e . ${LTGREEN}-v${NC}        The version of this deploy script.
    echo -e . ${LTGREEN}-u${NC}   example: ${LTGREEN}./deploy -u${NC}     Update the deploy script via svn.
    echo -e . ${LTGREEN}-d${NC}   example: ${LTGREEN}./deploy -d${NC}     Install daily drivers from gallaxy.
    echo .             You will be prompted for your svn credentials,
    echo .             If they are not already saved in the system.
    echo -e . ${LTGREEN}--help${NC}        This information.
    echo 
    echo 
}
function Repo()
{
echo . Installing Matrox Repository
    KERNEL=$(uname -r)
    
    echo -e ".......... ${LTGREEN}KERNEL = ${KERNEL}${NC}"
    echo "."
    echo . If a channel already exists, add another name at prompt.
    echo
    
    if [ "${KERNEL:0:7}" == "4.4.26-" ]; then
         echo .....Installing the Repo for 4.4.26 Kernel system..... 
         smart channel --remove-all -y
         smart channel --add mydb type=rpm-sys name="RPM Database" -y 
         smart channel --add http://jenkinshardware.matrox.com:8080/userContent/${RepoFile} -y
         smart channel --add matroxsv2repo type=rpm-md baseurl=http://mgibuildnexus.matrox.com:8081/repository/matroxsv2repo/ -y
         smart update
         smart channel --list
         smart channel --show
    elif [ "${KERNEL:0:7}" == "5.4.81-" ] || [ "${KERNEL:0:8}" == "5.4.129-" ]; then
         echo .....Installing the Repo for 5.4.81 Kernel system.....
         repocheck=$(cat /etc/dnf/dnf.conf | grep "meos-repo-4.00")
         if [ "$repocheck" == "" ]; then
            sudo bash -c 'echo -e "\n[meos-repo-4.00]\nname=meos-repo-4.00\nbaseurl=http://mgibuildnexus.matrox.com:8081/repository/meos-repo-4.00/\ngpgcheck=0" >> /etc/dnf/dnf.conf'
            dnf --enablerepo meos-repo-4.00 repolist
         else
            echo "Already Installed!"
         fi
    else 
         echo .....Installing the Repo for all Kernels other then 4.4.26.....         
             smart channel --remove-all -y
             smart channel --add mydb type=rpm-sys name="RPM Database" -y 
             smart channel --add http://jenkinshardware.matrox.com:8080/userContent/yocto.updates -y
             smart channel --add matroxsv2repo type=rpm-md baseurl=http://mgibuildnexus.matrox.com:8081/repository/matroxsv2repo/ -y
             smart update
             smart channel --list
             smart channel --show
    fi
    
}
function DailyFromGalaxy()
{
    read -p "Give me your username: " username
    read -p "Do you wish to see a build list of ${BRANCHVERSION}: (y,n) " yn
    case $yn in
        [Yy]* ) ssh ${username}@galaxy.matrox.com ls -d /export/storage/SV2/Daily/${BRANCHVERSION}/Build_*;;
        * ) ;;
    esac
    read -p "Give me your ${BRANCHVERSION} build to install example 012: " build
    echo .
    echo scp ${username}@galaxy.matrox.com:/export/storage/SV2/Daily/${BRANCHVERSION}/Build_${build}/MeOS/liberatus-runtime-*.rpm .
    scp ${username}@galaxy.matrox.com:/export/storage/SV2/Daily/${BRANCHVERSION}/Build_${build}/MeOS/liberatus-runtime-*.rpm .
    ls liberatus*
    LIBERATUSRUNTIME=$(ls -t liberatus-runtime-*.rpm | head -n 1)
    LIBERATUSRUNTIME=${LIBERATUSRUNTIME::-4}
    UninstallLiberratusViaSmartUninstall
    InstallLiberratusViaSmartInstall    
}
function SmartChannelFix()
{
    echo . Adding a channel in case it was somehow removed.
    echo .  If a channel already exists, ctrl-c to exit.
    echo
    if [ -z `smart channel --list` ]; then echo "Installing smart channel mydb ...." && smart channel --add mydb type=rpm-sys name="RPM Database" -y ; else echo "Smart channel already exists!" ; fi
    rm /var/lib/rpm/__db.*   
}
function UninstallLiberratusViaSmartUninstall()
{
    echo .....Uninstalling previous sv2 drivers via smart uninstaller, this may take up to 30 seconds.....
    smart remove liberatus-runtime --quiet
    exitcode=$?
    echo $exitcode
    if [ $exitcode == 0 ]
    then
    echo -e  liberatus-runtime ${LTGREEN}Uninstalled${NC}.
    fi
}

function UninstallLiberratusViaDnfUninstall()
{
    echo .....Uninstalling previous sv2 drivers via dnf uninstaller, this may take up to 30 seconds.....
    dnf remove liberatus-runtime --quiet -y
    exitcode=$?
    echo $exitcode
    if [ $exitcode == 0 ]
    then
    echo -e  liberatus-runtime ${LTGREEN}Uninstalled${NC}.
    fi
}

function SVNUpdate()
{

echo checking if subversion is installed   
 
    if [[ `rpm -qa | grep subversion ` ]] ; then
        
        echo Subversion is already installed

    else
        Repo
        echo Installing subversion
        dnf info subversion
        dnf install -y subversion
  
    fi
        echo svn co ${SVNPATHONSERVER} ${LOCALPATH}
        svn co ${SVNPATHONSERVER} ${LOCALPATH}/ --quiet
        cp ${LOCALPATH}/deploy.sh /home/root
        svn info ${LOCALPATH}/ | grep "Last Changed Rev"
        echo Update Meos_Scripts to home.
        ClearLocalPath
        echo svn co ${SVNSCRIPTS} ${LOCALPATH}
        svn co ${SVNSCRIPTS} ${LOCALPATH}/ --quiet
        cp ${LOCALPATH}/ConnectNode.sh /home/root  
        cp ${LOCALPATH}/DisconnectNode.sh /home/root
        cp ${LOCALPATH}/RunTestNow.sh /home/root
        cp ${LOCALPATH}/commonfunctions.sh /home/root
        cp ${LOCALPATH}/groups.sh /home/root
        cp ${LOCALPATH}/pyunzip.py /home/root    
    
}
function DeploySVNVersion()
{
    svn co ${SVNPATHONSERVER} /tmp/filedeploy/ --quiet
    echo last revision changed in SVN
    svn info /tmp/filedeploy/ | grep "Last Changed Rev"
    echo    
}
function InstallLiberratusViaSmartInstall()
{
    KERNEL=$(uname -r)
    echo .
    echo .
    if [ "${KERNEL:0:7}" == "4.4.26-" ]; then
         echo .....Installing the SV2 drivers and all required files including bins via rpm Install.....    
         rpm --nosignature -i --nodeps ${LIBERATUSRUNTIME}.rpm
    else
         echo .....Installing the SV2 drivers and all required files including bins via Smart Install.....         
         smart install -y ${LIBERATUSRUNTIME}.rpm
    fi

    echo .
    smart info liberatus-runtime
    echo -e . ${LTGREEN}To see which package is installed please type \"smart info liberatus-runtime\" ${NC}.
}

function InstallLiberratusViaDnfInstall()
{
    KERNEL=$(uname -r)
    echo .
    echo .
    if [ "${KERNEL:0:7}" == "5.4.81-" ] || [ "${KERNEL:0:8}" == "5.4.129-" ]; then
         echo .....Installing the SV2 drivers and all required files including bins via dnf Install.....    
         dnf install -y ${LIBERATUSRUNTIME}.rpm   
    fi
}

function PublicBuild()
{
    jenkinsprojectname=${jenkinsprojectpublicname}
    buildNumber=$buildNumberP
    echo ..... Setting build number to the last Successful Public 1.8 number = $buildNumber
    #echo fetching information from Jenkins.
    #buildNumber=$(curl -s  ${jenkinsprojectpublicname}/lastSuccessfulBuild/buildNumber)
    buildpath=${jenkinsprojectname}/${buildNumber}/artifact
    
    wget ${buildpath}/version -O versionFile
    version=`grep VERSION versionFile | awk -F "=" '{print $2}'`
    echo -e .....Using Project ${LTGREEN} Public from ${jenkinsprojectpublicname} ${NC}.....
  
}
#function RegularBuild()
#{
#     jenkinsprojectname=${jenkinsprojectname1_8}            
#     buildNumber=${buildNumber1_8}
#     echo ..... Setting build number to = $buildNumber
#     buildpath=${jenkinsprojectname}/${buildNumber}/artifact/sv2/build3.14             
#     
#     echo Getting LIBERATUSRUNTIME version number of the package.
#     wget ${buildpath}/install/usr/share/sv2Info/version -O versionFile
#     version=`grep VERSION versionFile | awk -F "=" '{print $2}'`
#}

function Var_4_4_Build()
{
    jenkinsprojectname=${jenkinsprojectname4_4}
    buildNumber=${buildNumber4_4}
    echo ..... Setting build number to = $buildNumber
    buildpath=${jenkinsprojectname}/${buildNumber}/artifact/sv2/build4.4.26          
    echo Getting LIBERATUSRUNTIME version number of the package.
    wget ${buildpath}/install/usr/share/sv2Info/version -O versionFile
    version=`grep VERSION versionFile | awk -F "=" '{print $2}'`

}

function Var_5_4_Build()
{
    jenkinsprojectname=${jenkinsprojectname5_4}
    buildNumber=${buildNumber5_4}
    echo ..... Setting build number to = $buildNumber
    buildpath=${jenkinsprojectname}/${buildNumber}/artifact/sv2/build5.4.81          
    echo Getting LIBERATUSRUNTIME version number of the package.
    wget ${buildpath}/install/usr/share/sv2Info/version -O versionFile
    version=`grep VERSION versionFile | awk -F "=" '{print $2}'`

}

function AVSLBuild()
{     
    echo . Copying last successful artifact from AVSL project.
    echo
    if [ -e "liberatus-runtime-AVSL-*.rpm" ]; then rm liberatus-runtime-AVSL-*.rpm; fi
    wget $jenkinsprojectAVSL/lastSuccessfulBuild/artifact/avslversion -O versionFile
    version=`grep AVSLVERSION versionFile | awk -F "=" '{print $2}'`
    AVSLVERSION=$(echo $version | cut -f4 -d'.')
    AVSL_SERVER_BRANCH=`grep AVSL_SERVER_BRANCH versionFile | awk -F "=" '{print $2}'`
    wget $jenkinsprojectAVSL/lastSuccessfulBuild/artifact/AVSL/build/liberatus-runtime-AVSL-${AVSL_SERVER_BRANCH}-${AVSLVERSION}.rpm   
    smart remove liberatus-runtime-avsl --quiet
    
    smart install -y liberatus-runtime-AVSL-${AVSL_SERVER_BRANCH}-${AVSLVERSION}.rpm    
    #systemctl daemon-reload
    #systemctl start avsl 
}

if [ "$1" == "--help" ] || [ "$1" == "-help" ] || [ "$1" == "/help" ] || [ "$1" == "help" ] || [ "$1" == "-h" ] || [ "$1" == "/h" ] || [ "$1" == "h" ] || [ "$1" == "/?" ]; then
    ShowHelp
    exit
fi

# Make sure that the file system is mounted read-write.
/home/root/fstab.sh
ClearLocalPath

if [ "$1" == "-repo" ]|| [ "$1" == "repo" ]|| [ "$1" == "/repo" ] || [ "$1" == "--repo" ]; then
    Repo
    exit
fi    

if [ "$1" == "daily" ] || [ "$1" == "-daily" ] || [ "$1" == "-d" ] || [ "$1" == "--d" ] || [ "$1" == "/d" ]; then
    DailyFromGalaxy
    exit
fi

if [ "$1" == "avsl" ] || [ "$1" == "-avsl" ] || [ "$1" == "--avsl" ] || [ "$1" == "/avsl" ]; then
    AVSLBuild
    exit
fi

if [ "$1" == "fix" ] || [ "$1" == "-fix" ] || [ "$1" == "--fix" ] || [ "$1" == "/fix" ]; then
    SmartChannelFix
   exit
fi

if [ "$1" == "-remove" ]|| [ "$1" == "remove" ]|| [ "$1" == "/remove" ] || [ "$1" == "-r" ] || [ "$1" == "r" ] || [ "$1" == "/r" ] ; then
    UninstallLiberratusViaSmartUninstall    
    exit
fi

if [ "$1" == "u" ] || [ "$1" == "-u" ] || [ "$1" == "/u" ]  || [ "$1" == "-update" ]  || [ "$1" == "--update" ] || [ "$1" == "update" ]; then
    SVNUpdate
    exit
fi

clear
 
#echo Deleting lastPromotedBuild file if exists.
#if [ -e "lastPromotedBuild" ]; then rm lastPromotedBuild; fi
#buildNumber1_8A=$(curl -s  ${jenkinsprojectname1_8}/lastSuccessfulBuild/buildNumber)
#echo wget ${jenkinsprojectname1_8}/lastSuccessfulBuild/artifact/lastPromotedBuild
#wget ${jenkinsprojectname1_8}/lastSuccessfulBuild/artifact/lastPromotedBuild
#promotion1_8=$(cat lastPromotedBuild)
#rm lastPromotedBuild
echo .
#echo fetching information from Jenkins for last Successful Public Build.
#buildNumberP=$(curl -s  ${jenkinsprojectpublicname}/lastSuccessfulBuild/buildNumber)
echo fetching information from Jenkins for last Successful jenkins project Kernel 4.4 Build.
buildNumber4_4=$(curl -s  ${jenkinsprojectname4_4}/lastSuccessfulBuild/buildNumber)
echo fetching information from Jenkins for last Successful jenkins project Kernel 5.4 Build.
buildNumber5_4=$(curl -s  ${jenkinsprojectname5_4}/lastSuccessfulBuild/buildNumber)

echo .
#echo -e ..... last Successful Build compiled on Jenkins for Yocto 1.6 = ${LTGREEN} ${buildNumberA} ${NC}
#echo -e ..... last Successful Build Promoted on Jenkins for Yocto 1.6 = ${LTGREEN} ${promotion} ${NC}
#echo -e "..... last Successful Build Compiled   on ${BRANCHFOLDERLEGACY} for Yocto 1.8 = ${LTGREEN} ${buildNumber1_8A}" ${NC}
#echo -e "..... last Successful Build Promoted   on ${BRANCHFOLDERLEGACY} for Yocto 1.8 = ${LTGREEN} ${promotion1_8}" ${NC}
#echo -e "..... last Successful Build Public on ${BRANCHFOLDER} for MeOS 3.0 = ${LTGREEN} ${buildNumberP}" ${NC}
echo -e "..... last Successful Build Kernel 4.4 on ${BRANCHFOLDER} for MeOS 3.0 = ${LTGREEN} ${buildNumber4_4}" ${NC}
echo -e "..... last Successful Build Kernel 5.4 on ${BRANCHVERSION4HARDCODED} for MeOS 4.0 = ${LTGREEN} ${buildNumber5_4}" ${NC}


if [ "$1" == "v" ] || [ "$1" == "-v" ] || [ "$1" == "/v" ]  || [ "$1" == "-version" ]  || [ "$1" == "--version" ] || [ "$1" == "version" ]; then
    echo .
    DeploySVNVersion    
    exit
fi

if [ "$1" == "" ]; then
    #buildNumber=$promotion
    buildNumber1_8=$promotion1_8
    echo ..... Setting build number to the promotion number = $promotion or $promotion1_8
else
    #buildNumber=$1
    buildNumber1_8=$1
    buildNumber4_4=$1
    echo ..... Setting build number to $1
fi
if [ "$1" == "last" ] || [ "$1" == "-last" ]; then
    #buildNumber=$buildNumberA
    buildNumber1_8=$buildNumber1_8A
    echo ..... Setting build number to the last Successful number = $buildNumber1_8
fi

KERNEL=$(uname -r)
echo -e ".......... ${LTGREEN}KERNEL = ${KERNEL}${NC}"
echo "."
 
if [ "${KERNEL:0:4}" == "3.10" ]; then 
          echo -e ".......... ${RED} Your Running a very old Kernel (${KERNEL}).${NC} .......... "
          echo -e ".......... ${RED} Please upgrade your box.${NC}                                .......... "
          echo -e ".......... ${RED} There are no drivers available any more for you.${NC}        .......... "
          exit 3
fi
if [ "${KERNEL:0:7}" == "3.14.4-" ]; then 
          buildpath=${jenkinsprojectname}/${buildNumber}/artifact/sv2/build3.14
          echo not yet supported version of your Kernel.
          echo -e ".......... ${RED} Your Running a very New Kernel (${KERNEL}).${NC} .......... "
          echo -e ".......... ${RED} Please Downgrade your box, or wait for it to be available in next few days..${NC}                                .......... "
          echo -e ".......... ${RED} There are no drivers available Yet, but should be available soon.${NC}        .......... "
          exit 3
fi
#if [ "${KERNEL:0:7}" == "3.14.39" ]; then         
#         if [ "$1" == "--public" ] || [ "$1" == "-public" ] || [ "$1" == "/public" ] || [ "$1" == "public" ] || [ "$1" == "-PUBLIC" ] || [ "$1" == "/PUBLIC" ] || [ "$1" == "public" ]; then         
#            PublicBuild
#         else
#            RegularBuild             
#         fi

#fi
if [ "${KERNEL:0:7}" == "4.4.13-" ]; then 
          echo not yet supported version of your Kernel.
          echo -e ".......... ${RED} Your Running an unsupported Kernel (${KERNEL}).${NC} .......... "
          echo -e ".......... ${RED} Please install another kernel on your box ..${NC}                                .......... "
          echo -e ".......... ${RED} There are no drivers available Yet,and will not be in the future .${NC}        .......... "
          exit 3
fi

if [ "${KERNEL:0:7}" == "4.4.26-" ]; then 
      Var_4_4_Build
fi

if [ "${KERNEL:0:7}" == "5.4.81-" ] || [ "${KERNEL:0:8}" == "5.4.129-" ]; then 
      Var_5_4_Build
fi

echo -e ${LTGREEN}build = $buildNumber${NC}

LIBERATUSRUNTIME=liberatus-runtime-${version}
echo -e ${LTGREEN}Version=${version}${NC}
    
echo -e .....Using ${LTGREEN}build${NC} number = ${LTGREEN} ${buildNumber} ${NC}.....
echo -e .....Using files from this location = ${LTGREEN}${buildpath}${NC}.....
echo .....Deleting existing rpm file of same name in root directory.....
if [ -e "${LIBERATUSRUNTIME}.rpm" ]; then rm ${LIBERATUSRUNTIME}.rpm; fi
echo -e .....Downloading ${LTGREEN}${LIBERATUSRUNTIME}.rpm${NC} using wget.....
echo -e Trying to Download ${LTGREEN}once${NC}.
echo downloading from this path ${buildpath}/${LIBERATUSRUNTIME}.rpm
wget ${buildpath}/${LIBERATUSRUNTIME}.rpm
exitcode=$?
echo $exitcode
if [ $exitcode != 0 ]
then
echo -e Trying to Download ${LTGREEN}twice${NC}.
wget ${buildpath}/${LIBERATUSRUNTIME}.rpm
fi
exitcode=$?
echo $exitcode from second wget
if [ $exitcode != 0 ]
then
echo wget ${buildpath}/${LIBERATUSRUNTIME}.rpm
echo .
echo .
echo -e ".......... ${RED}Cannot download the file, tried twice.  Please verify the path.${NC} .......... "
echo -e ".......... ${RED}Nothing downloaded and nothing installed.${NC} .........."
echo .
exit
fi

if [ $exitcode == 0 ]
then
        echo .
        if [ "${KERNEL:0:7}" == "5.4.81-" ] || [ "${KERNEL:0:8}" == "5.4.129-" ]; then 
             UninstallLiberratusViaDnfUninstall        
             InstallLiberratusViaDnfInstall        
        else
             UninstallLiberratusViaSmartUninstall        
             InstallLiberratusViaSmartInstall
        fi
fi


echo -e ".....Using build number = ${LTGREEN}${buildNumber}${NC}....."
timestamp=$(curl -s  ${jenkinsprojectname}/${buildNumber}/buildTimestamp)
echo -e .....Build on ${LTGREEN}${timestamp}${NC}.....
echo -e Using Kernel ${LTGREEN}${KERNEL}${NC}
echo .

if [ "${KERNEL:0:7}" == "5.4.81-" ] || [ "${KERNEL:0:8}" == "5.4.129-" ]; then 
             dnf info liberatus-runtime
             echo -e . ${LTGREEN}To see which package is installed please type \"dnf info liberatus-runtime\" ${NC}.      
        else
             smart info liberatus-runtime
             echo -e . ${LTGREEN}To see which package is installed please type \"smart info liberatus-runtime\" ${NC}.
        fi
        
        

